
#include "p33Fxxxx.h"
#include "adc.h"
#include "config.h"

signed short DMA_ADCBufferA[ADC_SAMPLES_PER_BUFFER] __attribute__((space(dma)));
signed short DMA_ADCBufferB[ADC_SAMPLES_PER_BUFFER] __attribute__((space(dma)));
unsigned char which_ADC_buffer;

static unsigned char adcs_at_next_interrupt;

extern signed short* local_record;
extern unsigned char local_record_pos, local_record_used;
extern unsigned char local_record_rates[LOCAL_BUFFERS];
extern unsigned char current_record_rate, next_record_rate;

#if defined(ADC_OVERSAMPLING) && ADC_OVERSAMPLING > 1
static unsigned char mem_buf_partial_record_pos;
#endif

void __attribute__((__interrupt__, no_auto_psv)) _DMA1Interrupt(void) {
  signed short* dest, * src;

  if( which_ADC_buffer )
    src = DMA_ADCBufferA;
  else
    src = DMA_ADCBufferB;
  which_ADC_buffer ^= 1;

#if defined(ADC_OVERSAMPLING) && ADC_OVERSAMPLING > 1
  if( adcs_at_next_interrupt && mem_buf_partial_record_pos == 0 ) {
#else
  if( adcs_at_next_interrupt ) {
#endif
    AD1CON3bits.ADCS = adcs_at_next_interrupt;
    adcs_at_next_interrupt = 0;
  }

  if( local_record_used < LOCAL_BUFFERS ) {
#if defined(ADC_OVERSAMPLING) && ADC_OVERSAMPLING > 1
    unsigned char i;
  #if ADC_OVERSAMPLING == 2
    dest = local_record + (SAMPLES_PER_BUFFER / ADC_OVERSAMPLING) * ((unsigned short)local_record_pos * ADC_OVERSAMPLING + mem_buf_partial_record_pos);
    for( i = 0; i < SAMPLES_PER_BUFFER / ADC_OVERSAMPLING; ++i ) {
      *dest = (src[0] + src[1]) >> 1;
      dest += 1;
      src += 2;
    }
  #else
    dest = local_record + (SAMPLES_PER_BUFFER / ADC_OVERSAMPLING) * ((unsigned short)local_record_pos * ADC_OVERSAMPLING + mem_buf_partial_record_pos);
    for( i = 0; i < SAMPLES_PER_BUFFER / ADC_OVERSAMPLING; ++i ) {
      signed short accum = 0;
      for( j = 0; j < ADC_OVERSAMPLING; ++j ) {
        accum += *src;
        ++src;
      }
      *dest = accum / ADC_OVERSAMPLING;
      ++dest;
    }
  #endif
    if( ++mem_buf_partial_record_pos == ADC_OVERSAMPLING ) {
      mem_buf_partial_record_pos = 0;

      local_record_rates[local_record_pos] = current_record_rate;
      current_record_rate = next_record_rate;
      if( ++local_record_pos == LOCAL_BUFFERS )
        local_record_pos = 0;
      ++local_record_used;
    }
#else
    memcpy(local_record + SAMPLES_PER_BUFFER * (unsigned short)local_record_pos, src, SAMPLES_PER_BUFFER * sizeof(signed short));
    local_record_rates[local_record_pos] = current_record_rate;
    if( ++local_record_pos == LOCAL_BUFFERS )
      local_record_pos = 0;
    ++local_record_used;
#endif
  }

  IFS0bits.DMA1IF = 0;
}

void init_adc(void) {
  AD1CON1bits.ASAM = 1;
  AD1CON1bits.SSRC = 7;
  AD1CON1bits.FORM = 1;//3;
  AD1CON1bits.AD12B = 1;
  AD1CON1bits.ADDMABM = 1;
#ifdef SLOW_CLOCK
  AD1CON3bits.ADCS = (16 / ADC_OVERSAMPLING)-1;
#else
  AD1CON3bits.ADCS = (32 / ADC_OVERSAMPLING)-1;
#endif
  AD1CON3bits.SAMC = 18;

  DMA1CONbits.MODE = 2;
  DMA1PAD = (volatile unsigned int)&ADC1BUF0; /* Point DMA to ADC1BUF0 */
  DMA1CNT = ADC_SAMPLES_PER_BUFFER-1;
  DMA1REQ = 13; /* Select ADC1 as DMA Request Source */
  DMA1STA = __builtin_dmaoffset(DMA_ADCBufferA);
  DMA1STB = __builtin_dmaoffset(DMA_ADCBufferB);
  IFS0bits.DMA1IF = 0; /* Clear DMA Interrupt Flag */
  IEC0bits.DMA1IE = 1; /* Set DMA Interrupt Enable Bit */
  DMA1CONbits.CHEN = 1; /* Enable DMA Channel 1 */

  AD1CON1bits.ADON = 1;
}

void adc_set_record_rate(unsigned char rate) {
  unsigned char adcs;
  switch(rate) {
//case 0:
  default:
    adcs = 32 / ADC_OVERSAMPLING;
    break;
  case 1:
    adcs = 48 / ADC_OVERSAMPLING;
    break;
  case 2:
    adcs = 64 / ADC_OVERSAMPLING;
    break;
  case 3:
    adcs = 128 / ADC_OVERSAMPLING;
    break;
  }
#ifdef SLOW_CLOCK
  adcs_at_next_interrupt = (adcs >> 1) - 1;
#else
  adcs_at_next_interrupt = adcs - 1;
#endif
}

